﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Ksiega" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Księga Przychodów i Rozchodów</title>
		<script runat="server">

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            miesiąc = new YearMonth(Date.Today);
        }
    
        YearMonth miesiąc;
        [Required]
        [Caption("Wydruk za miesiąc")]
				[Soneta.Tools.Priority(1)]
        public YearMonth Miesiąc {
            get { return miesiąc; }
            set {
                miesiąc = value;
                OnChanged(EventArgs.Empty);
            }
        }

			bool pokazNumerEwidencji = false;
			[Soneta.Tools.Priority(2)]
			[Caption("Pokaż nr ewidencji")]
			public bool PokazNumerEwidencji {
				get { return pokazNumerEwidencji; }
				set { pokazNumerEwidencji = value; OnChanged(EventArgs.Empty); }
			}

      bool pokazPodsumowanie = true;
      [Soneta.Tools.Priority(3)]
      [Caption("Pokaż podsumowanie")]
      public bool PokazPodsumowanie {
          get { return pokazPodsumowanie; }
          set { pokazPodsumowanie = value; OnChanged(EventArgs.Empty); }
      }        
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    FromTo miesiąc;
    decimal[] przeniesienie = new decimal[17];
    KPiR.KPiRWorker worker = new KPiR.KPiRWorker();
    
    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader["OKRES"] = Pars.Miesiąc.ToString();
        SectionPodsumowanie.Visible = Pars.PokazPodsumowanie;
        miesiąc = Pars.Miesiąc.ToFromTo();
        OkresObrachunkowy okres = (OkresObrachunkowy)dc[typeof(OkresObrachunkowy)];
        KsiegaModule ksiega = KsiegaModule.GetInstance(dc.Context);

        colS07.Caption = col07.Caption;
        colS08.Caption = col08.Caption;
        colS09.Caption = col09.Caption;
    
        colS10.Caption = col10.Caption;
        colS11.Caption = col11.Caption;
        //colS12.Caption = col12.Caption;
        colS13.Caption = col13.Caption;
        colS14.Caption = col14.Caption;
        colS15.Caption = col15.Caption;
    
        colS16.Caption = col16.Caption;
    
       Soneta.Business.View view = ksiega.Dziennik.WgKPiR.CreateView();
        view.Condition &= new FieldCondition.Equal("Okres", okres);
        view.Condition &= "KPiR.Lp>0";
        Grid.DataSource = view;
    
        Grid1.DataSource = new object[] {1, 2, 3};
    }
    
    void Grid_BeforeRow(Object sender, RowEventArgs args) {
        DekretBase dekret = (DekretBase)args.Row;
        bool sum = dekret.KPiR.Stan!=StanyZapisuKPiR.Przekreślony;
        if (dekret.Data<miesiąc.From) {
            args.VisibleRow = false;
            if (sum) {
                worker.Dekret = dekret;
                przeniesienie[ 7] += worker.K07.Value;
                przeniesienie[ 8] += worker.K08.Value;
                przeniesienie[ 9] += worker.K09.Value;
                przeniesienie[10] += worker.K10.Value;
                przeniesienie[11] += worker.K11.Value;
                //przeniesienie[12] += worker.K12.Value;
                przeniesienie[13] += worker.K13.Value;
                przeniesienie[14] += worker.K14.Value;
                przeniesienie[15] += worker.K15.Value;
                przeniesienie[16] += worker.K16.Value;
            }
        }
        else if (dekret.Data>miesiąc.To)
            args.VisibleRow = false;
        else {
            if (Pars.PokazNumerEwidencji)
                colNumerDokumentu.EditValue = string.Format("{0} ({1})", dekret.NumerDokumentu, dekret.NumerEwidencji);
            else
                colNumerDokumentu.EditValue = dekret.NumerDokumentu;

            worker.Dekret = dekret;
            SetCol(col07, worker.K07.Value, sum);
            SetCol(col08, worker.K08.Value, sum);
            SetCol(col09, worker.K09.Value, sum);
            SetCol(col10, worker.K10.Value, sum);
            SetCol(col11, worker.K11.Value, sum);
            //SetCol(col12, worker.K12.Value, sum);
            SetCol(col13, worker.K13.Value, sum);
            SetCol(col14, worker.K14.Value, sum);
            SetCol(col15, worker.K15.Value, sum);
            SetCol(col16, worker.K16.Value, sum);
        }
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        int n = (int)args.Row;
        switch (n) {
            case 1:
                colS07.EditValue = ObjToDec(col07.TotalValue);
                colS08.EditValue = ObjToDec(col08.TotalValue);
                colS09.EditValue = ObjToDec(col09.TotalValue);
                colS10.EditValue = ObjToDec(col10.TotalValue);
                colS11.EditValue = ObjToDec(col11.TotalValue);
                //colS12.EditValue = ObjToDec(col12.TotalValue);
                colS13.EditValue = ObjToDec(col13.TotalValue);
                colS14.EditValue = ObjToDec(col14.TotalValue);
                colS15.EditValue = ObjToDec(col15.TotalValue);
                //colS16.EditValue = ObjToDec(col16.TotalValue);
                colSInfo2.EditValue = "<strong>Suma miesiąca:</strong>";
                break;
            case 2:
                colS07.EditValue = przeniesienie[ 7];
                colS08.EditValue = przeniesienie[ 8];
                colS09.EditValue = przeniesienie[ 9];
                colS10.EditValue = przeniesienie[10];
                colS11.EditValue = przeniesienie[11];
                //colS12.EditValue = przeniesienie[12];
                colS13.EditValue = przeniesienie[13];
                colS14.EditValue = przeniesienie[14];
                colS15.EditValue = przeniesienie[15];
                //colS16.EditValue = przeniesienie[16];
                colSInfo2.EditValue = "<strong>Przeniesienie z poprzednich miesięcy:</strong>";
                break;
            case 3:
                colS07.EditValue = przeniesienie[ 7] + ObjToDec(col07.TotalValue);
                colS08.EditValue = przeniesienie[ 8] + ObjToDec(col08.TotalValue);
                colS09.EditValue = przeniesienie[ 9] + ObjToDec(col09.TotalValue);
                colS10.EditValue = przeniesienie[10] + ObjToDec(col10.TotalValue);
                colS11.EditValue = przeniesienie[11] + ObjToDec(col11.TotalValue);
                //colS12.EditValue = przeniesienie[12] + ObjToDec(col12.TotalValue);
                colS13.EditValue = przeniesienie[13] + ObjToDec(col13.TotalValue);
                colS14.EditValue = przeniesienie[14] + ObjToDec(col14.TotalValue);
                colS15.EditValue = przeniesienie[15] + ObjToDec(col15.TotalValue);
                //colS16.EditValue = przeniesienie[16] + ObjToDec(col16.TotalValue);
                colSInfo2.EditValue = "<strong>Razem od początku roku:</strong>";
                break;
        }
    }
    
    void SetCol(Soneta.Web.GridColumn col, decimal value, bool sum) {
        col.SumRow = sum;
        if (sum || value!=0) {
            col.Format = "{0:n}";
            col.EditValue = value;
        }
        else
            col.Format = "<center>-------------</center>";
    }
    
    decimal ObjToDec(object value) {
        return value==null ? 0m : (decimal)value;
    }
    
    void Msg(object obj) {
    }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="Form1" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" TopMargin="-1" BottomMargin="-1" RightMargin="-1" LeftMargin="-1"
				Landscape="True" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="PODATKOWA  KSIĘGA PRZYCHODÓW I ROZCHODÓW|Za %OKRES%" runat="server"></eb:ReportHeader>
			<p>
				<ea:Grid id="Grid" runat="server" ShowPrevAgrSum="InFooter" ShowPageSum="True" OnBeforeRow="Grid_BeforeRow"
					RowsInRow="2" RowTypeName="Soneta.Ksiega.DekretBase,Soneta.Ksiega" ShowAgrSum="True">
					<Columns>
						<ea:GridColumn Width="5" Align="Right" DataMember="KPiR.Lp" Caption="Lp.&lt;br&gt;&lt;br&gt;(1)"
							RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Left" DataMember="Data" Caption="Data zdarzenia&lt;br&gt;&lt;br&gt;(2)" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Left" ID="colNumerDokumentu" Caption="Nr dowodu&lt;br&gt;księgowego&lt;br&gt;(3)" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Left" DataMember="KPiR.NazwaKontrahenta" Caption="Kontrahent&lt;br&gt;imię i nazwisko (nazwa)&lt;br&gt;(4)" runat="server"></ea:GridColumn>
						<ea:GridColumn DataMember="KPiR.AdresKontrahenta" Caption="Kontrahent&lt;br&gt;adres&lt;br&gt;(5)" runat="server"></ea:GridColumn>
						<ea:GridColumn Align="Left" DataMember="Opis" RowSpan="2" Total="Info" Caption="Opis zdarz. gospodarczego&lt;br&gt;&lt;br&gt;(6)" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Wartość sprzedanych towar&#243;w i usług&lt;br&gt;&lt;br&gt;&lt;br&gt;(07)"
							HideZero="True" Format="{0:0.00}" ID="col07" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Total="Sum" Caption="Pozostałe przychody&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(08)"
							HideZero="True" Format="{0:0.00}" ID="col08" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Razem przych&#243;d&lt;br&gt;&lt;br&gt;(7+8)&lt;br&gt;&lt;br&gt;&lt;br&gt;(09)"
							HideZero="True" Format="{0:0.00}" ID="col09" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Zakup towar&#243;w handlowych i materiał&#243;w wg cen zakupu&lt;br&gt;(10)"
							HideZero="True" Format="{0:0.00}" ID="col10" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Total="Sum" Caption="Koszty uboczne zakupu&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(11)"
							HideZero="True" Format="{0:0.00}" ID="col11" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Total="Sum" Caption="Wynagro-&lt;br&gt;dzenia w got&#243;wce i w naturze&lt;br&gt;&lt;br&gt;&lt;br&gt;(12)"
							HideZero="True" Format="{0:0.00}" ID="col13" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Total="Sum" Caption="Pozostałe wydatki&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(13)"
							HideZero="True" Format="{0:0.00}" ID="col14" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Total="Sum" Caption="Razem wydatki&lt;br&gt;&lt;br&gt;(12+13)&lt;br&gt;&lt;br&gt;&lt;br&gt;(14)"
							HideZero="True" Format="{0:0.00}" ID="col15" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Caption="&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(15)"
							HideZero="True" Format="{0:0.00}" ID="col16" RowSpan="2" runat="server"></ea:GridColumn>
						<ea:GridColumn ID="GridColumn1" Width="20" DataMember="KPiR.Uwagi" RowSpan="2" Caption="Uwagi&lt;br&gt;&lt;br&gt;(16)" runat="server"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</p>
            <ea:Section ID="SectionPodsumowanie" runat="server" Width="100%">
			<p>
				<strong><font size="2">Podsumowanie:</font></strong>
				<br>
				<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow">
					<Columns>
						<ea:GridColumn Width="20" RightBorder="None" Align="Right" ID="colSInfo"></ea:GridColumn>
						<ea:GridColumn ID="colSInfo2"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="(07)" Format="{0:n}" ID="colS07"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Caption="(08)" Format="{0:n}" ID="colS08"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="(09)" Format="{0:n}" ID="colS09"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="(10)" Format="{0:n}" ID="colS10"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Caption="(11)" Format="{0:n}" ID="colS11"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Caption="(12)" Format="{0:n}" ID="colS13"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Caption="(13)" Format="{0:n}" ID="colS14"></ea:GridColumn>
						<ea:GridColumn Width="12" Align="Right" Caption="(14)" Format="{0:n}" ID="colS15"></ea:GridColumn>
						<ea:GridColumn Width="11" Align="Right" Caption="(15)" ID="colS16"></ea:GridColumn>
						<ea:GridColumn Width="20" ID="colSInfo3"></ea:GridColumn>
					</Columns>
				</ea:Grid>
    			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
			</p>				    		
			</ea:Section>	
		</form>
	</body>
</HTML>
